# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# This addon was created with the Serpens - Visual Scripting Addon.
# This code is generated from nodes and is not intended for manual editing.
# You can find out more about Serpens at <https://blendermarket.com/products/serpens>.


bl_info = {
    "name": "FurryVNE",
    "description": "",
    "author": "odes",
    "version": (1, 2, 0),
    "blender": (5, 0, 0),
    "location": "",
    "warning": "",
    "wiki_url": "",
    "tracker_url": "",
    "category": "3D View"
}


###############   IMPORTS
import bpy
from bpy.utils import previews
import os
import math
from bpy.app.handlers import persistent


###############   INITALIZE VARIABLES
furryvne = {
    "is_offsets": False, 
    }


###############   SERPENS FUNCTIONS
def exec_line(line):
    exec(line)

def sn_print(tree_name, *args):
    if tree_name in bpy.data.node_groups:
        item = bpy.data.node_groups[tree_name].sn_graphs[0].prints.add()
        for arg in args:
            item.value += str(arg) + ";;;"
        for area in bpy.context.screen.areas:
            area.tag_redraw()
    print(*args)

def sn_cast_string(value):
    return str(value)

def sn_cast_boolean(value):
    if type(value) == tuple:
        for data in value:
            if bool(data):
                return True
        return False
    return bool(value)

def sn_cast_float(value):
    if type(value) == str:
        try:
            value = float(value)
            return value
        except:
            return float(bool(value))
    elif type(value) == tuple:
        return float(value[0])
    elif type(value) == list:
        return float(len(value))
    elif not type(value) in [float, int, bool]:
        try:
            value = len(value)
            return float(value)
        except:
            return float(bool(value))
    return float(value)

def sn_cast_int(value):
    return int(sn_cast_float(value))

def sn_cast_boolean_vector(value, size):
    if type(value) in [str, bool, int, float]:
        return_value = []
        for i in range(size):
            return_value.append(bool(value))
        return tuple(return_value)
    elif type(value) == tuple:
        return_value = []
        for i in range(size):
            return_value.append(bool(value[i]) if len(value) > i else bool(value[0]))
        return tuple(return_value)
    elif type(value) == list:
        return sn_cast_boolean_vector(tuple(value), size)
    else:
        try:
            value = tuple(value)
            return sn_cast_boolean_vector(value, size)
        except:
            return sn_cast_boolean_vector(bool(value), size)

def sn_cast_float_vector(value, size):
    if type(value) in [str, bool, int, float]:
        return_value = []
        for i in range(size):
            return_value.append(sn_cast_float(value))
        return tuple(return_value)
    elif type(value) == tuple:
        return_value = []
        for i in range(size):
            return_value.append(sn_cast_float(value[i]) if len(value) > i else sn_cast_float(value[0]))
        return tuple(return_value)
    elif type(value) == list:
        return sn_cast_float_vector(tuple(value), size)
    else:
        try:
            value = tuple(value)
            return sn_cast_float_vector(value, size)
        except:
            return sn_cast_float_vector(sn_cast_float(value), size)

def sn_cast_int_vector(value, size):
    return tuple(map(int, sn_cast_float_vector(value, size)))

def sn_cast_color(value, use_alpha):
    length = 4 if use_alpha else 3
    value = sn_cast_float_vector(value, length)
    tuple_list = []
    for data in range(length):
        data = value[data] if len(value) > data else value[0]
        tuple_list.append(sn_cast_float(min(1, max(0, data))))
    return tuple(tuple_list)

def sn_cast_list(value):
    if type(value) in [str, tuple, list]:
        return list(value)
    elif type(value) in [int, float, bool]:
        return [value]
    else:
        try:
            value = list(value)
            return value
        except:
            return [value]

def sn_cast_blend_data(value):
    if type(value) in [tuple, bool, int, float, list]:
        return None
    elif type(value) == str:
        try:
            value = eval(value)
            return value
        except:
            return None
    else:
        return None

def sn_cast_enum(string, enum_values):
    for item in enum_values:
        if item[1] == string:
            return item[0]
        elif item[0] == string.upper():
            return item[0]
    return string


###############   IMPERATIVE CODE
#######   FurryVNE
def sn_handle_script_line_exception(exc, line):
    print("# # # # # # # # SCRIPT LINE ERROR # # # # # # # #")
    print("Line:", line)
    raise exc


@persistent
def depsgraph_update_post_handler_34A40(dummy):
    try: exec(r"furryvne['is_offsets'] = bpy.context.active_object != None and 'fvne_hash' in bpy.context.active_object.data")
    except Exception as exc: sn_handle_script_line_exception(exc, r"furryvne['is_offsets'] = bpy.context.active_object != None and 'fvne_hash' in bpy.context.active_object.data")
    if "EDIT_MESH"==bpy.context.mode or "SCULPT"==bpy.context.mode:
        pass # WARNING Script Start
        #import bpy
        try:
            a = bpy.context.active_object
            if r"fvne_hash" in a.data and a.active_shape_key_index == 0:

                def draw(self, context):
                    self.layout.label(text="YOU SHOULD NOT EDIT BASIS SHAPE.")
                bpy.context.window_manager.popup_menu(draw, title="WARNING!", icon='INFO')
        except:
            pass
        pass # WARNING Script End
    else:
        pass


###############   EVALUATED CODE
#######   FurryVNE
def sn_append_menu_0DDB0(self,context):
    try:
        layout = self.layout
        op = layout.operator("sna.transfer_using_basis_proximity",text=r"FVNE - Transfer using basis proximity",emboss=True,depress=False,icon_value=0)
    except Exception as exc:
        print(str(exc) + " | Error in Mesh Mt Shape Key Context Menu when adding to menu")


class SNA_OT_Transfer_Using_Basis_Proximity(bpy.types.Operator):
    bl_idname = "sna.transfer_using_basis_proximity"
    bl_label = "Transfer using basis proximity"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}


    @classmethod
    def poll(cls, context):
        return 2 == len(sn_cast_list(bpy.context.selected_objects))

    def execute(self, context):
        try:
            pass
        except Exception as exc:
            print(str(exc) + " | Error in execute function of Transfer using basis proximity")
        return {"FINISHED"}

    def invoke(self, context, event):
        try:
            pass # Transfer using vertex proximity Script Start
            #import bpy
            import mathutils

            def add_shape_to_active():
                bpy.ops.object.shape_key_add(from_mix=False)
                shape = bpy.context.active_object.data.shape_keys.key_blocks[-1]
                return shape

            def main():
                target = bpy.context.active_object
                source = [x for x in bpy.context.selected_objects if x != target][0]
                tree = mathutils.kdtree.KDTree(len(source.data.vertices))
                for vertex in source.data.vertices:
                    tree.insert(vertex.co, vertex.index)
                tree.balance()
                mapping = []
                old_area = bpy.context.area.type
                bpy.context.area.type = 'VIEW_3D'
                for vertex in target.data.vertices:
                    vec, index, distance = tree.find(vertex.co)
                    mapping.append(index)
                if target.data.shape_keys is None:
                    add_shape_to_active()
                for source_shape in source.data.shape_keys.key_blocks[1:]:
                    target_shape = add_shape_to_active()
                    target_shape.name = source_shape.name
                    for i in range(len(target.data.vertices)):
                        source_index = mapping[i]
                        offset = source_shape.data[source_index].co.copy() - source.data.vertices[source_index].co.copy()
                        target_shape.data[i].co = target.data.vertices[i].co.copy() + offset
                bpy.context.area.type = old_area
            main()
            pass # Transfer using vertex proximity Script End
        except Exception as exc:
            print(str(exc) + " | Error in invoke function of Transfer using basis proximity")
        return self.execute(context)

def sn_append_menu_A1822(self,context):
    try:
        layout = self.layout
        op = layout.operator("sna.import_offsets",text=r"FurryVNE offsets (.fvne_offsets)",emboss=True,depress=False,icon_value=0)
    except Exception as exc:
        print(str(exc) + " | Error in Topbar Mt File Import when adding to menu")

def sn_append_menu_F0928(self,context):
    try:
        layout = self.layout
        op = layout.operator("sna.difference_as_shape",text=r"FVNE - Difference as shape",emboss=True,depress=False,icon_value=0)
    except Exception as exc:
        print(str(exc) + " | Error in Mesh Mt Shape Key Context Menu when adding to menu")


class SNA_OT_Difference_As_Shape(bpy.types.Operator):
    bl_idname = "sna.difference_as_shape"
    bl_label = "Difference as shape"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}


    @classmethod
    def poll(cls, context):
        return 2 == len(sn_cast_list(bpy.context.selected_objects))

    def execute(self, context):
        try:
            pass
        except Exception as exc:
            print(str(exc) + " | Error in execute function of Difference as shape")
        return {"FINISHED"}

    def invoke(self, context, event):
        try:
            pass # difference as shape Script Start
            import bpy

            def deselect_all():
                bpy.ops.object.select_all(action='DESELECT')

            def set_active_object(obj, deselect_others=True):
                if deselect_others:
                    deselect_all()
                obj.select_set(True)
                bpy.context.view_layer.objects.active = obj

            def duplicate(obj):
                set_active_object(obj)
                bpy.ops.object.duplicate()
                return bpy.context.active_object

            def main():
                target = bpy.context.object
                source = [x for x in bpy.context.selected_objects if x != target][0]
                duplicated = duplicate(target)
                old_area = bpy.context.area.type
                bpy.context.area.type = 'VIEW_3D'
                set_active_object(duplicated)
                bpy.ops.object.shape_key_add(from_mix=True)
                duplicated.show_only_shape_key = True
                shape_key_vertex_data = duplicated.data.shape_keys.key_blocks[-1].data
                corrective = []
                for i in range(0, len(shape_key_vertex_data)):
                    diff = source.data.vertices[i].co - shape_key_vertex_data[i].co
                    corrective.append(diff + target.data.vertices[i].co)
                bpy.ops.object.delete()
                set_active_object(target)
                bpy.ops.object.shape_key_add(from_mix=False)
                target_shape_key = target.data.shape_keys.key_blocks[-1]
                for i in range(0, len(corrective)):
                    target_shape_key.data[i].co = corrective[i]
                target_shape_key.value = 1.0
                bpy.context.area.type = old_area
            main()
            pass # difference as shape Script End
        except Exception as exc:
            print(str(exc) + " | Error in invoke function of Difference as shape")
        return self.execute(context)


class SNA_OT_Import_Offsets(bpy.types.Operator):
    bl_idname = "sna.import_offsets"
    bl_label = "Import offsets"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}


    @classmethod
    def poll(cls, context):
        return True

    def execute(self, context):
        try:
            pass
        except Exception as exc:
            print(str(exc) + " | Error in execute function of Import offsets")
        return {"FINISHED"}

    def invoke(self, context, event):
        try:
            pass # offsets import Script Start
            #import bpy
            import os
            import struct
            from bpy.props import StringProperty, BoolProperty
            from bpy_extras.io_utils import ImportHelper
            from bpy.types import Operator
            from mathutils import kdtree, Vector
            import json
            little_endian = '<'
            little_endian_int = little_endian + 'i'
            little_endian_float = little_endian + 'f'
            little_endian_vector = '<fff'

            def create_kdtree_from_buffer(verts):
                tree = kdtree.KDTree(len(verts))
                for i,vertex in enumerate(verts):
                    tree.insert(vertex, i)
                tree.balance()
                return tree

            def read_int(f):
                (_read_int,) = struct.unpack(little_endian_int, f.read(4))
                return _read_int

            def read_shape(data):
                data.read(1)
                (floats_len,) = struct.unpack(little_endian_int, data.read(4))
                verts = []
                c = 0
                while c < floats_len:
                    vec = struct.unpack(little_endian_vector, data.read(12))
                    verts.append(Vector(vec))
                    c += 3
                return verts

            def _import(path):
                data = open(path, "rb")
                data.read(1) # s
                (hash_len,) = struct.unpack(little_endian_int, data.read(4))
                hash = data.read(hash_len)
                hash = hash.decode('utf-8')
                jsondata = json.loads(hash)
                # ############################
                data.read(1) # skip first
                obj_len = data.read(4)
                (obj_len,) = struct.unpack(little_endian_int, obj_len)
                temp_path = os.getenv('TEMP')
                filepath = temp_path + os.sep + 'fvne_import_character.obj'
                f = open(filepath, 'wb')
                f.write(data.read(obj_len))
                f.close()
                if bpy.app.version[0] < 4:
                    bpy.ops.import_scene.obj(filepath=filepath)
                else:
                    bpy.ops.wm.obj_import(filepath=filepath)
                verts = read_shape(data)
                # ############################
                tree = create_kdtree_from_buffer(verts)
                a = bpy.context.selected_objects[-1]
                a_verts = a.data.vertices
                a.data['fvne_hash'] = hash
                mapping = []
                for i,vertex in enumerate(a_verts):
                    co, index, dist = tree.find(vertex.co)
                    mapping.append(index)
                # ############################
                data.read(1) # i
                read_int(data) # 1
                shape_len = read_int(data)
                shapes = {}
                for i in range(shape_len):
                    data.read(1) # s
                    s_len = read_int(data)
                    shape_name = data.read(s_len)
                    shape_name = shape_name.decode('utf-8')
                    shape_verts = read_shape(data)
                    shapes[shape_name] = shape_verts
                # ############################
            #    context = bpy.context
            #    op_reset_context = context.area.type
            #    context.area.type = "VIEW_3D"
            #    current_mode = context.mode
            #    print(op_reset_context)
            #    print(context.area.type)
                try:
                    bpy.ops.object.mode_set(mode='OBJECT')
                except:
                    pass
                basis = a.shape_key_add()
                basis.name = 'basis'
                # shapes
                for shape_name,shape_verts in shapes.items():
                    a.shape_key_add()
                    a.data.shape_keys.key_blocks[-1].name = shape_name
                    shape_data = a.data.shape_keys.key_blocks[-1].data
                    for i,vertex in enumerate(shape_data):
                        index = mapping[i]
                        vertex.co = shape_verts[index].copy()
                # ...
                bpy.ops.object.transform_apply(location=True, rotation=True, scale=True)
            #    context.area.type = op_reset_context
                try:
                    # Ensure the first (non-basis) shape is visible/active so some rigs expect it
                    a.data.shape_keys.key_blocks[1].value = 1.0

                    # Robust handling for breasts / flatchested / belly / ass_hips values that may be present in jsondata['shapes']
                    # Read breasts value (if present) and decide whether to apply i_breasts or i_flatchested.
                    breasts_str = jsondata.get('shapes', {}).get('i_breasts')
                    if breasts_str is not None:
                        try:
                            f = float(breasts_str.strip().split(',')[0])
                        except Exception:
                            f = 0.0
                        if f < 0:
                            # Negative breasts -> flatchested value
                            shape_fl = a.data.shape_keys.key_blocks.get('i_flatchested')
                            if shape_fl is not None:
                                shape_fl.value = abs(f)
                            shape_br = a.data.shape_keys.key_blocks.get('i_breasts')
                            if shape_br is not None:
                                shape_br.value = 0.0
                        else:
                            shape_br = a.data.shape_keys.key_blocks.get('i_breasts')
                            if shape_br is not None:
                                shape_br.value = f
                            shape_fl = a.data.shape_keys.key_blocks.get('i_flatchested')
                            if shape_fl is not None:
                                shape_fl.value = 0.0

                    # Handle other inflation tweakables safely
                    for inflation in ('i_belly', 'i_ass_hips'):
                        val_str = jsondata.get('shapes', {}).get(inflation)
                        if val_str is None:
                            continue
                        try:
                            fv = float(val_str.strip().split(',')[0])
                        except Exception:
                            fv = 0.0
                        shape = a.data.shape_keys.key_blocks.get(inflation)
                        if shape is not None:
                            shape.value = abs(fv)

                except Exception as e:
                    # Catch any error during setting of shape key values and print informative message
                    print("Error setting tweakable shape key values:", e)
                try:
                    bpy.ops.object.mode_set(mode=current_mode)
                except:
                    pass
                data.close()
            #    print(context.area.type)
            #    print(bpy.context.area.type)
                print('success!')


            class OT_FVNE_TestOpenFilebrowser2(Operator, ImportHelper):
                bl_idname = "furryvne.open_filebrowser_open"
                bl_label = "Open"
                filter_glob: StringProperty(
                    default='*.fvne_offsets',
                    options={'HIDDEN'}
                )
                # import_path: StringProperty(
                    # name = "Path",
                    # description = "Path to the folder containing the files to import",
                    # default = os.path.join(os.path.join(os.environ['USERPROFILE']), 'Desktop') + os.sep,
                    # subtype = 'DIR_PATH'
                # )
                # some_boolean: BoolProperty(
                    # name='Do a thing',
                    # description='Do a thing with the file you\'ve selected',
                    # default=True,
                # )

                def invoke(self, context, event):
                    path = os.path.join(os.path.join(os.environ['USERPROFILE']), 'Desktop')
                    path = path + os.sep
                    self.filepath = path
                    wm = context.window_manager.fileselect_add(self)
                    return {'RUNNING_MODAL'}

                def execute(self, context):
                    """Do something with the selected file(s)."""
                    filename, extension = os.path.splitext(self.filepath)
                    # print('Selected file:', self.filepath)
                    # print('File name:', filename)
                    # print('File extension:', extension)
                    # print('Some Boolean:', self.some_boolean)
                    _import(self.filepath)
                    return {'FINISHED'}

            def register():
                bpy.utils.register_class(OT_FVNE_TestOpenFilebrowser2)

            def unregister():
                bpy.utils.unregister_class(OT_FVNE_TestOpenFilebrowser2)
            #if __name__ == "__main__": 

            def main_op():
                try:
                    unregister()
                except:
                    pass
                register()
                # test call
                bpy.ops.furryvne.open_filebrowser_open('INVOKE_DEFAULT')
            main_op() 
            pass # offsets import Script End
        except Exception as exc:
            print(str(exc) + " | Error in invoke function of Import offsets")
        return self.execute(context)



class SNA_OT_Export_Cloth(bpy.types.Operator):
    bl_idname = "sna.export_cloth"
    bl_label = "Export cloth"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}


    @classmethod
    def poll(cls, context):
        return True

    def execute(self, context):
        try:
            pass
        except Exception as exc:
            print(str(exc) + " | Error in execute function of Export cloth")
        return {"FINISHED"}

    def invoke(self, context, event):
        try:
            pass # cloth export Script Start
            #import bpy
            import os
            import struct
            from bpy.props import StringProperty, BoolProperty
            from bpy_extras.io_utils import ExportHelper
            from bpy.types import Operator

            def export(path, mesh_data):
                temp_path = os.getenv('TEMP')
                filepath = temp_path + os.sep + 'fvne_cloth_export.obj'
                if bpy.app.version[0] < 4:
                    bpy.ops.export_scene.obj(filepath=filepath, use_selection=True, use_triangles=False, keep_vertex_order=True)
                else:
                    bpy.ops.wm.obj_export(filepath=filepath, export_selected_objects=True, export_triangulated_mesh=False)                
                obj_data = open(filepath, 'rb').read()
                little_endian = '<'
                little_endian_int = little_endian + 'i'
                little_endian_float = little_endian + 'f'
                f = open(path, 'wb')
                f.write(struct.pack(little_endian_int, 0))
                f.write(b's')
                f.write(struct.pack(little_endian_int, len(obj_data)))
                f.write(obj_data)
                verts = [x.co for x  in mesh_data.vertices]
                if mesh_data.shape_keys != None:
                    for shape in mesh_data.shape_keys.key_blocks[1:]:
                        f.write(b's')
                        name = shape.name.encode('utf8')
                        f.write(struct.pack(little_endian_int, len(name)))
                        f.write(name)
                        vertex_floats = []
                        vertex_data = [x.co for x in shape.data]
                        for i,x in enumerate(vertex_data):
                            vec = x.copy()
                            vec -= verts[i]
                            vertex_floats.append(-vec.x)
                            vertex_floats.append(vec.z)
                            vertex_floats.append(-vec.y)
                        f.write(b'f')
                        f.write(struct.pack(little_endian_int, len(vertex_floats)))
                        for _f in vertex_floats:
                            f.write(struct.pack(little_endian_float, _f))
                f.close()

            def main(path):
                context = bpy.context
                op_reset_context = context.area.type
                context.area.type = "VIEW_3D"
                current_mode = context.mode
                bpy.ops.object.mode_set(mode='OBJECT')
                a = bpy.context.active_object
                old_active = a
                bpy.ops.object.select_all(action='DESELECT')
                a.select_set(True)
                bpy.ops.object.duplicate()
                new_active = bpy.context.active_object
                a = new_active
                bpy.ops.object.select_all(action='DESELECT')
                new_active.select_set(True)
                bpy.ops.object.transform_apply(location=True, rotation=True, scale=True)
                try:
                    export(path, new_active.data)
                except Exception as e:
                    print(e)
                bpy.ops.object.delete(use_global=False)
                old_active.select_set(True)
                bpy.context.view_layer.objects.active = old_active
                context.area.type = op_reset_context
                bpy.ops.object.mode_set(mode=current_mode)


            class OT_TestOpenFilebrowser(Operator, ExportHelper):
                bl_idname = "furryvne.open_filebrowser_save"
                bl_label = "Export"
                filename_ext = '.fvne_cloth'
                filter_glob: StringProperty(
                    default='*.fvne_cloth',
                    options={'HIDDEN'}
                )
            #    some_boolean: BoolProperty(
            #        name='Do a thing',
            #        description='Do a thing with the file you\'ve selected',
            #        default=True,
            #    )

                def execute(self, context):
                    """Do something with the selected file(s)."""
                    filename, extension = os.path.splitext(self.filepath)
                    print('Selected file:', self.filepath)
                    print('File name:', filename)
                    print('File extension:', extension)
                    #print('Some Boolean:', self.some_boolean)
                    main(self.filepath)
                    return {'FINISHED'}

            def register():
                bpy.utils.register_class(OT_TestOpenFilebrowser)

            def unregister():
                bpy.utils.unregister_class(OT_TestOpenFilebrowser)

            def main_op():
                try:
                    unregister()
                except:
                    pass
                register()
                if len(bpy.context.active_object.modifiers):
                    self.report({"ERROR"}, message='Please apply modifiers before exporting!')
                    return
                bpy.ops.furryvne.open_filebrowser_save('INVOKE_DEFAULT')
            #main(r'C:\Users\Dev\Desktop\lol.text.obj.tmp')
            main_op()
            pass # cloth export Script End
        except Exception as exc:
            print(str(exc) + " | Error in invoke function of Export cloth")
        return self.execute(context)


class SNA_PT_FurryVNE_A7365(bpy.types.Panel):
    bl_label = "FurryVNE"
    bl_idname = "SNA_PT_FurryVNE_A7365"
    bl_space_type = "PROPERTIES"
    bl_region_type = "WINDOW"
    bl_context = 'data'
    bl_order = 0


    @classmethod
    def poll(cls, context):
        return True

    def draw_header(self, context):
        try:
            layout = self.layout
        except Exception as exc:
            print(str(exc) + " | Error in FurryVNE panel header")

    def draw(self, context):
        try:
            layout = self.layout
            op = layout.operator("sna.export_offsets",text=r"Export offsets",emboss=True,depress=False,icon_value=707)
            op = layout.operator("sna.export_cloth",text=r"Export cloth",emboss=True,depress=False,icon_value=707)
        except Exception as exc:
            print(str(exc) + " | Error in FurryVNE panel")


class SNA_OT_Export_Offsets(bpy.types.Operator):
    bl_idname = "sna.export_offsets"
    bl_label = "Export offsets"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}


    @classmethod
    def poll(cls, context):
        return furryvne["is_offsets"]

    def execute(self, context):
        try:
            pass
        except Exception as exc:
            print(str(exc) + " | Error in execute function of Export offsets")
        return {"FINISHED"}

    def invoke(self, context, event):
        try:
            pass # offsets export Script Start
            #import bpy
            import os
            import struct
            from bpy.props import StringProperty, BoolProperty
            from bpy_extras.io_utils import ExportHelper
            from bpy.types import Operator
            from mathutils import kdtree, Vector
            little_endian = '<'
            little_endian_int = little_endian + 'i'
            little_endian_float = little_endian + 'f'

            def write_vectors(f, vectors):
                floats = []
                for x in vectors:
                    floats.append(-x.x)
                    floats.append(x.z)
                    floats.append(-x.y)
                f.write(b'f')
                f.write(struct.pack(little_endian_int, len(floats)))
                for _f in floats:
                    f.write(struct.pack(little_endian_float, _f))

            def write_shape(f, basis, shape):
                f.write(b's')
                name = shape.name.encode('utf8')
                f.write(struct.pack(little_endian_int, len(name)))
                f.write(name)
                offsets = [shape.data[i].co - basis[i] for i in range(0, len(basis))]
                write_vectors(f, offsets)

            def main(path):    
                f = open(path, "wb")
                a = bpy.context.active_object
                hash = a.data['fvne_hash'].encode('utf8')
                f.write(b's')
                f.write(struct.pack(little_endian_int, len(hash)))
                f.write(hash)
                write_vectors(f, [x.co for x in a.data.vertices])
                basis = [x.co for x in a.data.vertices]
                tweakables = a.data.shape_keys.key_blocks[1:]
            #    tweakables = [x for x in a.data.shape_keys.key_blocks if x.name.startswith('ut_')]
            #    adjustables = [x for x in a.data.shape_keys.key_blocks if x.name.startswith('ua_')]
                f.write(b'i')
                f.write(struct.pack(little_endian_int, 1))
                f.write(struct.pack(little_endian_int, len(tweakables)))
                for tweakable in tweakables:
                    write_shape(f, basis, tweakable)
            #    f.write(b'i')
            #    f.write(struct.pack(little_endian_int, 1))
            #    f.write(struct.pack(little_endian_int, len(adjustables)))
            #    
            #    for adjustable in adjustables:
            #        write_shape(f, basis, adjustable)
                f.close()


            class OT_TestOpenFilebrowserExport2(Operator, ExportHelper):
                bl_idname = "furryvne.open_filebrowser_save2"
                bl_label = "Export"
                filename_ext = '.fvne_offsets_export'
                filter_glob: StringProperty(
                    default='*.fvne_offsets_export',
                    options={'HIDDEN'}
                )
            #    some_boolean: BoolProperty(
            #        name='Do a thing',
            #        description='Do a thing with the file you\'ve selected',
            #        default=True,
            #    )

                def execute(self, context):
                    """Do something with the selected file(s)."""
                    filename, extension = os.path.splitext(self.filepath)
                    print('Selected file:', self.filepath)
                    print('File name:', filename)
                    print('File extension:', extension)
                    #print('Some Boolean:', self.some_boolean)
                    main(self.filepath)
                    return {'FINISHED'}

            def register():
                bpy.utils.register_class(OT_TestOpenFilebrowserExport2)

            def unregister():
                bpy.utils.unregister_class(OT_TestOpenFilebrowserExport2)
            # if __name__ == "__main__":

            def main_op():
                try:
                    unregister()
                except:
                    pass
                register()
                # test call
                bpy.ops.furryvne.open_filebrowser_save2('INVOKE_DEFAULT')
            main_op()
            pass # offsets export Script End
        except Exception as exc:
            print(str(exc) + " | Error in invoke function of Export offsets")
        return self.execute(context)


###############   REGISTER ICONS
def sn_register_icons():
    icons = []
    bpy.types.Scene.furryvne_icons = bpy.utils.previews.new()
    icons_dir = os.path.join( os.path.dirname( __file__ ), "icons" )
    for icon in icons:
        bpy.types.Scene.furryvne_icons.load( icon, os.path.join( icons_dir, icon + ".png" ), 'IMAGE' )

def sn_unregister_icons():
    bpy.utils.previews.remove( bpy.types.Scene.furryvne_icons )


###############   REGISTER PROPERTIES
def sn_register_properties():
    pass

def sn_unregister_properties():
    pass


###############   REGISTER ADDON
def register():
    sn_register_icons()
    sn_register_properties()
    bpy.utils.register_class(SNA_OT_Transfer_Using_Basis_Proximity)
    bpy.utils.register_class(SNA_OT_Difference_As_Shape)
    bpy.utils.register_class(SNA_OT_Import_Offsets)
    bpy.utils.register_class(SNA_OT_Export_Cloth)
    bpy.utils.register_class(SNA_PT_FurryVNE_A7365)
    bpy.utils.register_class(SNA_OT_Export_Offsets)
    bpy.app.handlers.depsgraph_update_post.append(depsgraph_update_post_handler_34A40)
    bpy.types.MESH_MT_shape_key_context_menu.append(sn_append_menu_0DDB0)
    bpy.types.TOPBAR_MT_file_import.append(sn_append_menu_A1822)
    bpy.types.MESH_MT_shape_key_context_menu.append(sn_append_menu_F0928)


###############   UNREGISTER ADDON
def unregister():
    sn_unregister_icons()
    sn_unregister_properties()
    bpy.types.MESH_MT_shape_key_context_menu.remove(sn_append_menu_F0928)
    bpy.types.TOPBAR_MT_file_import.remove(sn_append_menu_A1822)
    bpy.types.MESH_MT_shape_key_context_menu.remove(sn_append_menu_0DDB0)
    bpy.app.handlers.depsgraph_update_post.remove(depsgraph_update_post_handler_34A40)
    bpy.utils.unregister_class(SNA_OT_Export_Offsets)
    bpy.utils.unregister_class(SNA_PT_FurryVNE_A7365)
    bpy.utils.unregister_class(SNA_OT_Export_Cloth)
    bpy.utils.unregister_class(SNA_OT_Import_Offsets)
    bpy.utils.unregister_class(SNA_OT_Difference_As_Shape)
    bpy.utils.unregister_class(SNA_OT_Transfer_Using_Basis_Proximity)